#include <Adafruit_DotStar.h>
#include <SPI.h>
#include <SdFat.h>
#include <SdFatUtil.h>
#include <SFEMP3Shield.h>


#define NUMPIXELS 30

//#define DATAPIN    11
//#define CLOCKPIN   13
//Adafruit_DotStar strip = Adafruit_DotStar(
//                         NUMPIXELS, DATAPIN, CLOCKPIN, DOTSTAR_BRG);
Adafruit_DotStar strip = Adafruit_DotStar(NUMPIXELS, DOTSTAR_BRG);


const int magSensor = 3;
//const int toyPin = 10;
const int dwellPin = A0;
volatile int dwell;
volatile int timer;


SdFat sd;
SFEMP3Shield MP3player;
int8_t current_song = 1;
boolean began = false;

int      head  = 0, tail = -10; // Index of first 'on' and 'off' pixels
uint32_t color = 0xFF0000;      // 'On' color (starts red)

void setup() {
  Serial.begin(9600);

  strip.begin();
  strip.show();

  if (!sd.begin(SD_SEL, SPI_FULL_SPEED)) sd.initErrorHalt();
  if (!sd.chdir("/")) sd.errorHalt("sd.chdir");
  MP3player.begin();

  pinMode(magSensor, INPUT);
  pinMode(toyPin, OUTPUT);
  digitalWrite(toyPin, LOW);

  attachInterrupt(digitalPinToInterrupt(3), magCheck, LOW);

}

void loop() {

  while (timer != 0) {
    lightsOn();
    toyOn();
    musicOn();
    timer--;

    Serial.print("time ");
    Serial.println(timer);
    delay(1000);

  }
  if (timer == 0) {
    lightsOff();
    toyOff();
    musicOff();
  }

}

void magCheck() {
  timer = map(analogRead(dwellPin), 0, 700, 40, 5);
  /* every time mag is LOW, update timer to keep going
    Change the last 2 numbers to increase or decrease difficulty range
    Currently it takes in the values of the potentiometer (0 to 700)
    that were found when testing the potentiometer individually
    and converts them to a range of 40 to 5
    this means when the pot is lower, it will be a higher number
    giving the child more time to pedal
  */
}


void lightsOn() {
  strip.setPixelColor(head, color); // 'On' pixel at head
  strip.setPixelColor(tail, 0);     // 'Off' pixel at tail
  strip.show();                     // Refresh strip

  if (++head >= NUMPIXELS) {        // Increment head index.  Off end of strip?
    head = 0;                       //  Yes, reset head index to start
    if ((color >>= 8) == 0)         //  Next color (R->G->B) ... past blue now?
      color = 0xFF0000;             //   Yes, reset to red
  }
  if (++tail >= NUMPIXELS) tail = 0; // Increment, reset tail index
}

void lightsOff() {
  for (uint8_t i = 0; i < NUMPIXELS; i++) {
    strip.setPixelColor(i, strip.Color(0, 0, 0));
    strip.show();
  }
}

void toyOn() {
  digitalWrite(toyPin, HIGH);
}

void toyOff() {
  digitalWrite(toyPin, LOW);
}

void musicOn() {

  if (MP3player.getState() == paused_playback) { //In the middle of song: resume track
    MP3player.resumeMusic();
  } else if (!MP3player.isPlaying() && !began) { //Before the first song: play track
    MP3player.playTrack(current_song);
    began = true;
  } else if (!MP3player.isPlaying() && began) { //Between songs: move to next track and play
    current_song++;
    MP3player.playTrack(current_song);
  }

}

void musicOff() {
  MP3player.pauseMusic();
}

void allOn() {
  strip.setPixelColor(head, color); // 'On' pixel at head
  strip.setPixelColor(tail, 0);     // 'Off' pixel at tail
  strip.show();                     // Refresh strip

  if (++head >= NUMPIXELS) {        // Increment head index.  Off end of strip?
    head = 0;                       //  Yes, reset head index to start
    if ((color >>= 8) == 0)         //  Next color (R->G->B) ... past blue now?
      color = 0xFF0000;             //   Yes, reset to red
  }
  if (++tail >= NUMPIXELS) tail = 0; // Increment, reset tail index

  if (MP3player.getState() == paused_playback) { //In the middle of song: resume track
    MP3player.resumeMusic();
  } else if (!MP3player.isPlaying() && !began) { //Before the first song: play track
    MP3player.playTrack(current_song);
    began = true;
  } else if (!MP3player.isPlaying() && began) { //Between songs: move to next track and play
    current_song++;
    MP3player.playTrack(current_song);
  }
}

void allOff() {
  for (uint8_t i = 0; i < NUMPIXELS; i++) {
    strip.setPixelColor(i, strip.Color(0, 0, 0));
    strip.show();
  }
  MP3player.pauseMusic();
  Serial.println("off");
}

